<p align="center">
    <img src="https://github.com/zen-mod/ZEN/raw/master/extras/assets/logo/black/ZEN-Logo.png#gh-light-mode-only" width="512">
    <img src="https://github.com/zen-mod/ZEN/raw/master/extras/assets/logo/white/ZEN-Logo.png#gh-dark-mode-only" width="512">
</p>

<p align="center">
    <a href="https://github.com/zen-mod/ZEN/releases">
        <img src="https://img.shields.io/github/release/zen-mod/ZEN.svg?style=flat-square&label=Version" alt="Zeus Enhanced Version">
    </a>
    <a href="https://github.com/zen-mod/ZEN/issues">
        <img src="https://img.shields.io/github/issues-raw/zen-mod/ZEN.svg?style=flat-square&label=Issues" alt="Zeus Enhanced Issues">
    </a>
    <a href="https://discord.gg/kN7Jnhr">
        <img src="https://img.shields.io/discord/364823341506363392.svg?label=Discord&style=flat-square&colorB=7683D5" alt="Zeus Enhanced Discord">
    </a>
    <a href="https://github.com/zen-mod/ZEN/blob/master/LICENSE">
        <img src="https://img.shields.io/badge/License-GPLv3-red.svg?style=flat-square" alt="Zeus Enhanced License">
    </a>
</p>

<p align="center">
    <sup><strong>Requires the latest version of <a href="https://github.com/CBATeam/CBA_A3/releases">CBA A3</a>.</strong></sup>
</p>

**Zeus Enhanced**, also known as **ZEN**, is an Arma 3 mod aimed at improving and expanding the functionality of the Zeus real-time editor.

Zeus Enhanced is built with communities who use Zeus as their primary mission making tool in mind by enabling curators with powerful tools to create dynamic scenarios in an efficient manner.
For an in-depth breakdown of the features and frameworks please visit the [website](https://zen-mod.github.io/ZEN).

This mod is built using the same foundation and design standards as the ACE3 Project.
Special thanks to the [ACE3 Team](http://ace3mod.com/team.html) for their open source nature and permission to use their systems, without their work this would not be possible.

## Features

- A lot of powerful new modules, as well as improved vanilla modules.
- Completely rewritten attributes system available for all objects.
- Context menu that provides quick access to common Zeus actions.
- Ability to create custom compositions through Zeus.
- Settings to customize the Zeus display (move display to edge, remove watermark, etc.).
- Ability to disable live search to reduce lag when searching through a lot of items.
- Overhauled markers tree with markers sorted into categories.
- Rewritten, faster remote controlling of units.
- 3DEN editor object preview images in Zeus.
- Ability to create and edit area markers through Zeus.
- Player visibility indicator to help ensure mission adjustments are not made in view of players.
- Placement preview that enables precise object placement on surfaces.
- Vehicle customization garage made specifically for Zeus.
- Various bug fixes and quality of life improvements to the Zeus interface.
- Settings to control Zeus camera properties such as speed and available vision modes.
- Zeus camera flashlight for easier editing at night.
- New waypoint types such as paradrop available through Zeus.

## Contributing

You can help out with the ongoing development by looking for potential bugs in our code base, or by contributing new features. We are always welcoming new pull requests containing bug fixes, refactors and new features. We have a list of tasks and bugs on our issue tracker on GitHub. Please comment on issues you want to contribute with, to avoid duplicating effort.

To contribute something to ZEN, simply fork this repository and submit your pull requests for review by other collaborators. Remember to add yourself to the author array of any PBO you will be editing and the [`AUTHORS.txt`](https://github.com/zen-mod/ZEN/blob/master/AUTHORS.txt) file; including a valid email address.

### Submitting Issues and Feature Requests

Please use our [Issue Tracker](https://github.com/zen-mod/ZEN/issues) to report a bug, propose a feature, or suggest changes to the existing ones.

## License

Zeus Enhanced is licensed under the GNU General Public License ([GPLv3](https://github.com/zen-mod/ZEN/blob/master/LICENSE)).
